﻿using System;
using Microsoft.SharePoint;

namespace GetListItems
{
   class Program
   {
      static void Main(string[] args)
      {
         using (SPSite site = new SPSite("http://contoso.de"))
         {
            using (SPWeb web = site.OpenWeb())
            {
               SPList listOrders = web.Lists.TryGetList("Bestellungen");

               // Collection der Listenelemente einlesen
               SPListItemCollection items = listOrders.Items;

               // Collection iterieren
               foreach (SPListItem i in items)
               {
                  // Zugriff auf Standardeigenschaften
                  string title = i.Title;
                  int id = i.ID;

                  Console.WriteLine("{0} ({1})", title, id);

                  // Benutzerdefinierte Spalten auslesen
                  string article = i["Artikel"] != null ?
                     i["Artikel"].ToString() : String.Empty;

                  string customer = i["Kunde"] != null ?
                     i["Kunde"].ToString() : String.Empty;

                  int amount = i["Menge"] != null ?
                     int.Parse(i["Menge"].ToString()) : 0;

                  // Erzeugung SPFieldLookupValue Objekte
                  SPFieldLookupValue customerLookup =
                     new SPFieldLookupValue(customer);

                  SPFieldLookupValue articleLookup =
                     new SPFieldLookupValue(article);

                  // Ausgabe der Daten
                  Console.WriteLine("Bestellung {0} ({1})",
                     i.Title, i.ID);
                  Console.WriteLine("> Kunde: {0}",
                     customerLookup.LookupValue);
                  Console.WriteLine("> Artikel: {0}",
                     articleLookup.LookupValue);
                  Console.WriteLine("> Anzahl: {0}\n",
                     amount);
               }
            }
         }
      }
   }
}